<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



include 'includes/conexao.php';

$erro = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = intval($_POST['codigo']);

    $stmt = $conexao->prepare("SELECT id FROM apps WHERE codigo = ?");
    $stmt->execute([$codigo]);

    if ($stmt->rowCount() > 0) {
        header("Location: loja1.php?codigo=$codigo");
        exit;
    } else {
        $erro = true;
    }
}
// Inclui o layout principal com <html>, <head> e <body>
include 'includes/header.php';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Acesso Restrito</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            margin: 0;
            background: #0f0f1a;
            color: #00f0ff;
            font-family: 'Segoe UI', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            padding: 20px;
        }

        .glass-box {
            background: rgba(15, 15, 26, 0.8);
            border: 2px solid #00f0ff;
            border-radius: 18px;
            padding: 40px;
            box-shadow: 0 0 40px #00f0ff66;
            backdrop-filter: blur(12px);
            text-align: center;
            max-width: 400px;
            width: 100%;
        }

        h1 {
            margin-bottom: 20px;
            font-size: 1.8rem;
            text-shadow: 0 0 10px #00f0ff88;
        }

        input[type="number"] {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 10px;
            font-size: 1.1rem;
            margin-bottom: 20px;
            text-align: center;
            outline: none;
            background: #001622;
            color: #00f0ff;
            box-shadow: inset 0 0 8px #00f0ff44;
        }

        .neon-button {
            padding: 12px 25px;
            border: 2px solid #00f0ff;
            border-radius: 12px;
            background: transparent;
            color: #00f0ff;
            font-size: 1rem;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .neon-button:hover {
            background: #00f0ff;
            color: #0f0f1a;
            box-shadow: 0 0 20px #00f0ffdd, 0 0 40px #00f0ffaa;
        }

        .error {
            color: #ff4d4d;
            margin-bottom: 15px;
            text-shadow: 0 0 5px #ff4d4d88;
        }
    </style>
</head>
<body>
    <form method="POST" class="glass-box">
        <h1>🔐 Digite seu código de acesso</h1>
        <?php if ($erro): ?>
            <div class="error">Código inválido. Tente novamente.</div>
        <?php endif; ?>
        <input type="number" name="codigo" placeholder="Digite o código" required />
        <button type="submit" class="neon-button">Acessar App</button>
    </form>
    
    
    <script>
    setTimeout(() => {
        const error = document.querySelector('.error');
        if (error) {
            error.style.opacity = '0';
            error.style.transition = 'opacity 0.5s ease';
            setTimeout(() => error.remove(), 500); // Remove do DOM após a transição
        }
    }, 2000); // 2 segundos
</script>

</body>
</html>
