<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->

// Pasta destino + nome fixo da logo
$destino = 'logo/logo.png';

// Garante que a pasta existe
if (!is_dir('logo')) {
    mkdir('logo', 0775, true);
}

$erro = '';
$sucesso = false;

// Upload de arquivo
if (isset($_FILES['logo_arquivo']) && $_FILES['logo_arquivo']['error'] === UPLOAD_ERR_OK) {
    $temp = $_FILES['logo_arquivo']['tmp_name'];
    if (move_uploaded_file($temp, $destino)) {
        $sucesso = true;
    } else {
        $erro = "Erro ao mover o arquivo enviado.";
    }

// Download da imagem via URL
} elseif (!empty($_POST['logo_url'])) {
    $url = $_POST['logo_url'];

    $allowed_extensions = ['png', 'jpg', 'jpeg', 'gif', 'webp'];
    $ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION));
    if (!in_array($ext, $allowed_extensions)) {
        $erro = "URL não é de uma imagem válida.";
    } else {
        $imagem = @file_get_contents($url);
        if ($imagem !== false) {
            if (file_put_contents($destino, $imagem)) {
                $sucesso = true;
            } else {
                $erro = "Erro ao salvar a imagem da URL.";
            }
        } else {
            $erro = "Erro ao baixar imagem da URL.";
        }
    }
} else {
    $erro = "Nenhuma imagem foi enviada ou informada por URL.";
}

if ($sucesso) {
    // Criar versão da logo: timestamp atual
    $versao = date('Ymd-His');

    // Pega protocolo (http ou https)
    $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";

    // Pega domínio atual (host)
    $dominio = $_SERVER['HTTP_HOST'];

    // Caminho base do script atual
    $caminhoBase = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

    // Monta URL completa para a logo (flexível e dinâmico)
    $urlLogo = $protocolo . "://" . $dominio . $caminhoBase . "/logo/logo.png";

    // Monta o array com dados da versão
    $dadosVersao = [
        'version' => $versao,
        'url' => $urlLogo
    ];

    // Salva JSON no arquivo logo_version.json
    file_put_contents('logo/logo_version.json', json_encode($dadosVersao, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8" />
<title>Alterar Logo - Resultado</title>
<meta name="viewport" content="width=device-width, initial-scale=1" />
<style>
body {
    margin: 0; padding: 0; min-height: 100vh; background-color: #0f0f1a; font-family: Arial, sans-serif;
}
.main-content {
    padding: 40px 20px 20px; display: flex; justify-content: center;
}
.glass-container {
    background: rgba(15, 15, 26, 0.7); backdrop-filter: blur(12px);
    border: 1px solid #00f0ff; border-radius: 15px; padding: 30px;
    width: 600px; height: 200px; box-shadow: 0 0 25px rgba(0, 240, 255, 0.2);
    display: flex; flex-direction: column; justify-content: center; text-align: center;
}
.alert {
    padding: 12px; border-radius: 8px; margin-bottom: 20px; text-align: center; width: 100%; box-sizing: border-box;
}
.neon-success {
    background: rgba(0, 255, 136, 0.1); border: 1px solid #00ff88; color: #00ff88;
}
.neon-error {
    background: rgba(255, 85, 85, 0.1); border: 1px solid #ff5555; color: #ff5555;
}
a {
    color: #00f0ff; text-decoration: underline;
}
</style>
</head>
<body>
<div class="main-content">
    <div class="glass-container">
        <?php if ($sucesso): ?>
            <div class="alert neon-success">
                Logo atualizada com sucesso! Redirecionando em 3 segundos...
            </div>
            <script>
                setTimeout(() => {
                    window.location.href = "salvar_logo.php";
                }, 3000);
            </script>
        <?php else: ?>
            <div class="alert neon-error">
                <?= htmlspecialchars($erro) ?><br><br>
                <a href="salvar_logo.php">Voltar para o formulário</a>
            </div>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
