<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Painel de Controle</title>
    <style>
        :root {
            --ciano: #00f0ff;
            --preto-transparente: rgba(0, 0, 20, 0.7);
        }

        body {
            margin: 0;
            font-family: 'Arial', sans-serif;
            background: #0f0f1a;
            color: white;
        }

        /* Sidebar */
        .sidebar {
            width: 250px;
            height: 100vh;
            background: var(--preto-transparente);
            backdrop-filter: blur(10px);
            border-right: 1px solid var(--ciano);
            box-shadow: 0 0 20px rgba(0, 240, 255, 0.2);
            position: fixed;
            padding: 20px;
            top: 0;
            left: 0;
            transition: transform 0.3s ease-in-out;
            z-index: 1000;
        }

        /* Sidebar escondida no mobile */
        .sidebar.closed {
            transform: translateX(-100%);
        }

        .brand {
            text-align: center;
            margin-bottom: 30px;
            color: var(--ciano);
            font-size: 1.5rem;
            text-shadow: 0 0 10px var(--ciano);
        }

        .nav-link {
            display: block;
            padding: 12px;
            margin: 10px 0;
            color: white;
            text-decoration: none;
            border: 1px solid var(--ciano);
            border-radius: 5px;
            transition: all 0.3s;
            text-align: center;
        }

        .nav-link:hover {
            background: var(--ciano);
            color: black;
            box-shadow: 0 0 15px var(--ciano);
        }

        /* Conteúdo principal */
        .main-content {
            margin-left: 250px;
            padding: 20px;
            min-height: 100vh;
            transition: margin-left 0.3s ease-in-out;
        }

        /* Quando sidebar fechada, conteúdo ocupa a tela toda */
        .main-content.expanded {
            margin-left: 0;
        }

        /* Botão toggle */
        .toggle-btn {
            position: fixed;
            top: 15px;
            left: 260px;
            background: var(--ciano);
            border: none;
            border-radius: 4px;
            padding: 8px 12px;
            cursor: pointer;
            color: #0f0f1a;
            font-weight: bold;
            font-size: 1.2rem;
            box-shadow: 0 0 10px var(--ciano);
            transition: left 0.3s ease-in-out;
            z-index: 1100;
        }

        /* Ajuste do botão toggle quando sidebar fechada */
        .toggle-btn.shifted {
            left: 15px;
        }

        /* RESPONSIVO */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.open {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .toggle-btn {
                left: 15px;
                top: 15px;
            }
        }
    </style>
</head>
<body>

    <div class="sidebar closed" id="sidebar">
        <div class="brand">Painel Admin</div>
        <a href="dashboard.php" class="nav-link">🤖 DASHBOARD</a>
        <a href="visualizar.php" class="nav-link">📱 APPS SALVOS</a>
        <a href="minhaloja.php" class="nav-link">🏬 LOJA SEM CÓDIGO</a>
        <a href="loja1.php" class="nav-link">💻 LOJA CÓDIGO</a>
        <a href="update.php" class="nav-link">🆙 ATUALIZAR APP</a>
         <a href="alterar_logo.php" class="nav-link">📸 UPDATE LOGO</a>
         <a href="profile.php" class="nav-link">🥸 PROFILE</a>
        <a href="logout.php" class="nav-link">🚪 Sair</a>
    </div>
    </div>

    <div class="main-content">
    <!-- O conteúdo específico de cada página virá aqui --> 

    <button class="toggle-btn" id="toggleBtn">☰</button>

    

    <script>
        const sidebar = document.getElementById('sidebar');
        const toggleBtn = document.getElementById('toggleBtn');
        const mainContent = document.getElementById('mainContent');

        toggleBtn.addEventListener('click', () => {
            if (window.innerWidth <= 768) {
                // Mobile/tablet: toggle classe 'open' da sidebar
                sidebar.classList.toggle('open');
            } else {
                // Desktop: toggle fechar/abrir sidebar
                sidebar.classList.toggle('closed');
                mainContent.classList.toggle('expanded');
                toggleBtn.classList.toggle('shifted');
            }
        });

        // Opcional: fecha sidebar ao clicar fora dela no mobile
        window.addEventListener('click', (e) => {
            if(window.innerWidth <= 768) {
                if(!sidebar.contains(e.target) && !toggleBtn.contains(e.target)) {
                    sidebar.classList.remove('open');
                }
            }
        });

        // Quando a janela for redimensionada, ajusta sidebar e conteúdo
        window.addEventListener('resize', () => {
            if(window.innerWidth > 768) {
                sidebar.classList.remove('open');
                sidebar.classList.remove('closed');
                mainContent.classList.remove('expanded');
                toggleBtn.classList.remove('shifted');
            } else {
                sidebar.classList.add('closed');
                mainContent.classList.add('expanded');
                toggleBtn.classList.add('shifted');
            }
        });

        // Inicializa estado certo baseado no tamanho da tela
        window.dispatchEvent(new Event('resize'));
    </script>

</body>
</html>
