<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();
include 'includes/conexao.php';


// Redireciona se já estiver logado
if (isset($_SESSION['logado'])) {
    header("Location: dashboard.php");
    exit;
}

// Processa o login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = trim($_POST['usuario'] ?? '');
    $senha = $_POST['senha'] ?? '';

    try {
        $stmt = $conexao->prepare("SELECT id, senha_hash, nivel_acesso FROM usuarios WHERE usuario = ?");
        $stmt->execute([$usuario]);
        $dados = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($dados && password_verify($senha, $dados['senha_hash'])) {
            $_SESSION['logado'] = true;
            $_SESSION['usuario_id'] = $dados['id'];
            $_SESSION['nivel_acesso'] = $dados['nivel_acesso'];
            
            $update = $conexao->prepare("UPDATE usuarios SET ultimo_login = NOW() WHERE id = ?");
            $update->execute([$dados['id']]);
            
            header("Location: dashboard.php");
            exit;
        } else {
            $erro = "Credenciais inválidas!";
        }
    } catch (PDOException $e) {
        $erro = "Erro no sistema: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal Futurista | Login</title>
    <style>
        :root {
            --primary: #00f0ff;
            --secondary: #7b2cbf;
            --dark: #0f0f1a;
            --darker: #070710;
            --light: #e2e2e2;
            --error: #ff3860;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            font-family: 'Segoe UI', 'Roboto', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            color: var(--light);
            overflow: hidden;
        }
        
        /* Efeitos de partículas futuristas */
        .particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
        
        .particle {
            position: absolute;
            background: var(--primary);
            border-radius: 50%;
            opacity: 0.5;
        }
        
        /* Container principal */
        .login-container {
            background: rgba(15, 15, 26, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 240, 255, 0.2);
            border-radius: 16px;
            padding: 2.5rem;
            width: 100%;
            max-width: 600px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow: hidden;
            z-index: 1;
            animation: fadeIn 0.8s ease-out;
        }
        
        .login-container::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(123, 44, 191, 0.1),
                rgba(0, 240, 255, 0.1)
            );
            transform: rotate(30deg);
            z-index: -1;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .login-header h1 {
            color: var(--primary);
            font-size: 1.8rem;
            margin-bottom: 0.5rem;
            font-weight: 600;
            letter-spacing: 1px;
        }
        
        .login-header p {
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.9rem;
        }
        
        .login-form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }
        
        .input-group {
            position: relative;
        }
        
        .input-group input {
            width: 100%;
            padding: 1rem 1rem 1rem 3rem;
            background: rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(0, 240, 255, 0.3);
            border-radius: 8px;
            color: white;
            font-size: 0.95rem;
            transition: all 0.3s ease;
        }
        
        .input-group input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(0, 240, 255, 0.2);
        }
        
        .input-group input::placeholder {
            color: rgba(255, 255, 255, 0.5);
        }
        
        .input-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary);
        }
        
        .login-btn {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: var(--dark);
            border: none;
            padding: 1rem;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-top: 0.5rem;
        }
        
        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 240, 255, 0.4);
        }
        
        .error-message {
            color: var(--error);
            text-align: center;
            font-size: 0.9rem;
            margin-top: 1rem;
            animation: shake 0.5s;
        }
        
        /* Animações */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            20%, 60% { transform: translateX(-5px); }
            40%, 80% { transform: translateX(5px); }
        }
        
        /* Efeitos de hover futuristas */
        .glow-on-hover {
            position: relative;
            z-index: 0;
        }
        
        .glow-on-hover::before {
            content: '';
            background: linear-gradient(
                45deg,
                #00f0ff, #7b2cbf, #00f0ff, #7b2cbf
            );
            position: absolute;
            top: -2px;
            left: -2px;
            background-size: 400%;
            z-index: -1;
            filter: blur(5px);
            width: calc(100% + 4px);
            height: calc(100% + 4px);
            opacity: 0;
            transition: opacity 0.3s ease-in-out;
            border-radius: 10px;
            animation: glowing 20s linear infinite;
        }
        
        .glow-on-hover:hover::before {
            opacity: 1;
        }
        
        @keyframes glowing {
            0% { background-position: 0 0; }
            50% { background-position: 400% 0; }
            100% { background-position: 0 0; }
        }
        
        /* Responsividade */
        @media (max-width: 480px) {
            .login-container {
                padding: 1.5rem;
                margin: 0 1rem;
            }
        }
    </style>
</head>
<body>
    <!-- Efeito de partículas -->
    <div class="particles" id="particles"></div>
    
    <div class="login-container">
        <div class="login-header">
            <h1>PORTAL ADMIN</h1>
            <p>Acesse o painel de controle</p>
        </div>
        
        <form method="POST" class="login-form">
            <div class="input-group">
                <i class="input-icon fas fa-user"></i>
                <input type="text" name="usuario" placeholder="Usuário" required>
            </div>
            
            <div class="input-group">
                <i class="input-icon fas fa-lock"></i>
                <input type="password" name="senha" placeholder="Senha" required>
            </div>
            
            <button type="submit" class="login-btn glow-on-hover">
                ACESSAR SISTEMA
            </button>
            
            <?php if (!empty($erro)): ?>
                <div class="error-message"><?php echo htmlspecialchars($erro); ?></div>
            <?php endif; ?>
        </form>
    </div>
    
    <!-- Font Awesome para ícones -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    
    <!-- Script para partículas -->
    <script>
        // Cria partículas futuristas
        document.addEventListener('DOMContentLoaded', function() {
            const particlesContainer = document.getElementById('particles');
            const particleCount = 30;
            
            for (let i = 0; i < particleCount; i++) {
                const particle = document.createElement('div');
                particle.classList.add('particle');
                
                // Posição aleatória
                const posX = Math.random() * 100;
                const posY = Math.random() * 100;
                
                // Tamanho aleatório
                const size = Math.random() * 3 + 1;
                
                // Animação aleatória
                const duration = Math.random() * 20 + 10;
                const delay = Math.random() * 5;
                
                particle.style.width = `${size}px`;
                particle.style.height = `${size}px`;
                particle.style.left = `${posX}%`;
                particle.style.top = `${posY}%`;
                particle.style.animation = `float ${duration}s ease-in-out ${delay}s infinite alternate`;
                
                particlesContainer.appendChild(particle);
            }
            
            // Adiciona estilo dinâmico para a animação das partículas
            const style = document.createElement('style');
            style.textContent = `
                @keyframes float {
                    0% { transform: translate(0, 0); opacity: 0.3; }
                    50% { opacity: 0.8; }
                    100% { transform: translate(${Math.random() * 100 - 50}px, ${Math.random() * 100 - 50}px); opacity: 0.3; }
                }
            `;
            document.head.appendChild(style);
        });
    </script>
</body>
</html>