<?php


//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



include 'includes/conexao.php';

if (!isset($_GET['codigo'])) {
    header('Location: acesso.php');
    exit;
}

$codigo = intval($_GET['codigo']);

$stmt = $conexao->prepare("SELECT * FROM apps WHERE codigo = ?");
$stmt->execute([$codigo]);
$app = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$app) {
    header('Location: acesso.php?erro=1');
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<link rel="icon" href="caminho/do/favicon.ico" type="image/x-icon">

<title><?= htmlspecialchars($app['nome']) ?> - App</title>
<style>
    * { box-sizing: border-box; }
    body {
        margin: 0;
        background-color: #0f0f1a;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #cceeffdd;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 30px 15px;
    }

    h1 {
        color: #00f0ff;
        text-shadow: 0 0 12px #00f0ffbb;
        font-size: 2.5rem;
        margin-bottom: 60px;
        user-select: none;
    }

    .app-grid {
        width: 100%;
        max-width: 700px;
        display: grid;
        grid-template-columns: 1fr;
        gap: 28px;
    }

    .app-card {
        background: rgba(15, 15, 26, 0.75);
        border: 2px solid #00f0ff;
        border-radius: 18px;
        padding: 20px;
        backdrop-filter: blur(16px);
        box-shadow: 0 0 25px #00f0ff55;
        display: flex;
        flex-direction: column;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
        cursor: default;
    }
    .app-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 0 45px #00f0ffcc, 0 0 65px #00f0ffaa;
    }

    .app-image {
        width: 100%;
        height: 180px;
        border-radius: 14px;
        overflow: hidden;
        margin-bottom: 20px;
        background: #001622;
        display: flex;
        justify-content: center;
        align-items: center;
        color: #00f0ff66;
        font-size: 1rem;
        user-select: none;
    }
    .app-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 14px;
    }

    .app-info h2 {
        color: #00f0ff;
        margin: 0 0 12px 0;
        font-size: 1.5rem;
        text-shadow: 0 0 12px #00f0ffbb;
    }
    .app-info p {
        flex-grow: 1;
        white-space: pre-wrap;
        line-height: 1.4;
        font-size: 1rem;
        margin-bottom: 30px;
        color: #a0dfffcc;
    }

    .buttons-group {
        display: flex;
        gap: 14px;
        flex-wrap: wrap;
        justify-content: center;
    }
    .neon-button {
        background: transparent;
        border: 2.5px solid #00f0ff;
        color: #00f0ff;
        padding: 12px 20px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        text-decoration: none;
        user-select: none;
        transition: all 0.3s ease;
        text-align: center;
        display: inline-block;
        flex: 1 1 calc(50% - 14px);
        max-width: calc(50% - 14px);
        box-sizing: border-box;
    }
    .neon-button:hover {
        background: #00f0ff;
        color: #0f0f1a;
        box-shadow: 0 0 20px #00f0ffdd, 0 0 40px #00f0ffaa;
        transform: translateY(-3px);
    }

    .buttons-group.single-button .neon-button {
        flex: 1 1 100%;
        max-width: 100%;
    }

    @media (max-width: 600px) {
        .buttons-group {
            flex-direction: column;
            gap: 16px;
            align-items: stretch;
        }
        .neon-button {
            flex: 1 1 100%;
            max-width: 100%;
        }
    }

    @keyframes pulse {
        0%, 100% {
            transform: scale(1);
            filter: drop-shadow(0 0 5px #00f0ff);
        }
        50% {
            transform: scale(1.2);
            filter: drop-shadow(0 0 20px #00f0ff);
        }
    }

    h1 span.emoji-pulse {
        display: inline-block;
        animation: pulse 2s infinite ease-in-out;
    }
</style>
</head>
<body>

<h1><span class="emoji-pulse">📲</span> App Liberado</h1>

<div class="app-grid">
    <div class="app-card">
        <div class="app-image">
            <?php if ($app['imagens'] && file_exists('assets/imagens/' . $app['imagens'])): ?>
                <img src="<?= 'assets/imagens/' . htmlspecialchars($app['imagens']) ?>" alt="<?= htmlspecialchars($app['nome']) ?>">
            <?php else: ?>
                Sem imagem
            <?php endif; ?>
        </div>
        <div class="app-info">
            <h2><?= htmlspecialchars($app['nome']) ?></h2>
            <p><?= nl2br(htmlspecialchars($app['info'])) ?></p>
        </div>
        <div class="buttons-group <?= (($app['url'] && $app['apk']) ? '' : 'single-button') ?>">
            <?php if ($app['url']): ?>
                <a href="<?= htmlspecialchars($app['url']) ?>" target="_blank" rel="noopener noreferrer" class="neon-button">Visitar</a>
            <?php endif; ?>
            <?php if ($app['apk'] && file_exists('assets/apks/' . $app['apk'])): ?>
                <a href="<?= 'assets/apks/' . htmlspecialchars($app['apk']) ?>" download class="neon-button">Download APK</a>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
