<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<----------------------------------------------------------->



session_start();

$mensagem = '';
$tipo = '';

if (!empty($_SESSION['msg_sucesso'])) {
    $mensagem = $_SESSION['msg_sucesso'];
    $tipo = 'sucesso';
    unset($_SESSION['msg_sucesso']);
}
if (!empty($_SESSION['msg_erro'])) {
    $mensagem = $_SESSION['msg_erro'];
    $tipo = 'erro';
    unset($_SESSION['msg_erro']);
}

include 'includes/header.php';

$apk_dir = __DIR__ . '/assets/apks/';
$img_dir = __DIR__ . '/assets/imagens/';

$apk_files = array_filter(scandir($apk_dir), function($file) use ($apk_dir) {
    return is_file($apk_dir . $file) && preg_match('/\.apk$/i', $file);
});

$img_files = array_filter(scandir($img_dir), function($file) use ($img_dir) {
    return is_file($img_dir . $file) && preg_match('/\.(png|jpg|jpeg|gif)$/i', $file);
});

$apps = [];
foreach ($apk_files as $apk_file) {
    $base_name = pathinfo($apk_file, PATHINFO_FILENAME);

    $image_file = null;
    foreach ($img_files as $img_file) {
        if (pathinfo($img_file, PATHINFO_FILENAME) === $base_name) {
            $image_file = $img_file;
            break;
        }
    }

    $apps[] = [
        'nome' => ucfirst(str_replace('_', ' ', $base_name)),
        'apk' => $apk_file,
        'imagens' => $image_file ?? 'default.png',
        'info' => 'Descrição do app não disponível.',
        'id' => $base_name
    ];
}
?>

<?php if (!empty($mensagem)): ?>
    <div id="flashMsg" class="msg <?= $tipo ?>">
        <?= htmlspecialchars($mensagem) ?>
    </div>
<?php endif; ?>

<div class="glass-container">
    <h1 class="neon-title">📲 MEUS APPS CADASTRADOS</h1>

    <div class="apps-grid">
        <?php foreach ($apps as $app): ?>
            <div class="app-card">
                <div class="app-image">
                    <img src="assets/imagens/<?= htmlspecialchars($app['imagens']) ?>" alt="<?= htmlspecialchars($app['nome']) ?>">
                </div>
                <h3><?= htmlspecialchars($app['nome']) ?></h3>
                <p><?= htmlspecialchars($app['info']) ?></p>

                <div class="app-actions">
                    <a href="assets/apks/<?= htmlspecialchars($app['apk']) ?>" class="btn download-btn" download>⬇️ Download</a>
                    <!--<a href="editar_app.php?id=<?= urlencode($app['id']) ?>" class="btn edit-btn">✏️ Editar</a>-->
                    <a href="excluir_app.php?id=<?= urlencode($app['id']) ?>" class="btn delete-btn" onclick="return confirm('Tem certeza?')">🗑️ Excluir</a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<style>
body {
    background: #121212;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #eee;
    margin: 0;
    padding: 20px;
}

.msg {
    padding: 12px 20px;
    border-radius: 10px;
    font-weight: bold;
    max-width: 500px;
    margin: 20px auto;
    text-align: center;
    box-shadow: 0 0 12px rgba(0,0,0,0.3);
    opacity: 1;
    transition: opacity 0.5s ease-out;
}

.msg.sucesso {
    background-color: #00f0ff;
    color: #0a0a10;
}

.msg.erro {
    background-color: #ff4d4d;
    color: white;
}

.glass-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    background: rgba(255 255 255 / 0.05);
    border-radius: 15px;
    box-shadow: 0 8px 32px 0 rgba(0,0,0,0.7);
    backdrop-filter: blur(10px);
}

.neon-title {
    text-align: center;
    font-size: 2.8rem;
    color: #00fff7;
    text-shadow:
        0 0 5px #00fff7,
        0 0 10px #00fff7,
        0 0 20px #00fff7,
        0 0 40px #00fff7;
    margin-bottom: 40px;
}

.apps-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 25px;
}

@media (max-width: 900px) {
    .apps-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 600px) {
    .apps-grid {
        grid-template-columns: 1fr;
    }
}

.app-card {
    background: rgba(255 255 255 / 0.07);
    border-radius: 12px;
    padding: 20px;
    box-shadow:
        0 4px 6px rgba(0,0,0,0.3),
        inset 0 0 10px rgba(0,255,255,0.2);
    display: flex;
    flex-direction: column;
    align-items: center;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.app-card:hover {
    transform: translateY(-8px);
    box-shadow:
        0 12px 20px rgba(0,255,255,0.7),
        inset 0 0 20px rgba(0,255,255,0.4);
}

.app-image img {
    width: 120px;
    height: 120px;
    object-fit: contain;
    border-radius: 15px;
    margin-bottom: 15px;
    box-shadow: 0 0 15px #00fff7aa;
}

.app-card h3 {
    margin: 0 0 10px;
    font-size: 1.3rem;
    text-align: center;
    color: #00e5ff;
}

.app-card p {
    font-size: 0.9rem;
    color: #aaa;
    text-align: center;
    margin-bottom: 20px;
    min-height: 40px;
}

.app-actions {
    display: flex;
    justify-content: center;
    gap: 12px;
    width: 100%;
}

.btn {
    flex: 1;
    padding: 10px 0;
    border-radius: 8px;
    font-weight: 600;
    font-size: 0.95rem;
    text-align: center;
    cursor: pointer;
    user-select: none;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
    text-decoration: none;
    color: #121212;
    box-shadow: 0 3px 8px rgba(0,0,0,0.25);
}

.download-btn {
    background: #00ffc8;
}
.download-btn:hover {
    background: #00e5b0;
    box-shadow: 0 0 10px #00ffc8;
}

.edit-btn {
    background: #ffd600;
}
.edit-btn:hover {
    background: #e6c300;
    box-shadow: 0 0 10px #ffd600;
}

.delete-btn {
    background: #ff3b3b;
    color: white;
}
.delete-btn:hover {
    background: #e53030;
    box-shadow: 0 0 12px #ff3b3b;
}
</style>

<script>
    setTimeout(() => {
        const msg = document.getElementById('flashMsg');
        if (msg) {
            msg.style.opacity = '0';
            setTimeout(() => msg.remove(), 500);
        }
    }, 2000);
</script>

<?php include 'includes/footer.php'; ?>
